<?php

   /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    * 
    * Classe che descrive il tipo di dato Immagine, usato per ora solo nei componenti, ma in seguito anche per 
    * le immagini delle gallerie e del portfolio
    */

class Immagine {
    private $db;
    private $id;
    private $idContenuto;
    private $tipoImmagine; 
    private $percorso;
    private $descrizione; 
    private $posizione;

    function __construct($db,$id, $idContenuto=0, $tipoImmagine="", $percorso="", $descrizione="", $posizione=0) {
        $this->db = $db;
        $this->id = $id;
        $this->idContenuto = $idContenuto;
        $this->tipoImmagine = $tipoImmagine;
        $this->percorso = $percorso;
        $this->descrizione = $descrizione;
        $this->posizione = $posizione;
    }

    /*
     * metodo per la creazione della categoria
     */
    function crea() {
        $query = "INSERT INTO `geec_immagini` (`id`, `tipoImmagine`, `idContenuto`, `percorso`, `descrizione`, `posizione`)
                    VALUES (NULL, '$this->tipoImmagine', '$this->idContenuto', '$this->percorso', '$this->descrizione',$this->posizione);";
        $this->id = $this->db->eseguiQueryCreazione($query);
        return $this->id;
    }

    /*
     * qui va aggiunto un parametro alias che deve essere passato dall'utente
     */
    function modifica() {
        $query = "UPDATE `geec_immagini` SET  tipoImmagine='$this->tipoImmagine', idContenuto='$this->idContenuto', percorso='$this->percorso', descrizione='$this->descrizione', posizione='$this->posizione' WHERE id=$this->id";
        $this->id = $this->db->eseguiQueryCreazione($query);
    }

    function elimina() {
        $this->db->eseguiQueryCancellazione("geec_immagini",$this->id);
    }
        
    function caricaDatiDalDatabase() {
        $datiImmagine        = $this->db->leggiSingolaRiga("geec_immagini",$this->id);
        $this->idContenuto   = $datiImmagine["idContenuto"];
        $this->tipoImmagine  = $datiImmagine["tipoImmagine"];
        $this->percorso      = $datiImmagine["percorso"];
        $this->descrizione   = $datiImmagine["descrizione"];
        $this->posizione     = $datiImmagine["posizione"];
    }
    
    function getId() {
        return $this->id;
    }

    function getIdContenuto() {
        return $this->idContenuto;
    }

    function getTipoImmagine() {
        return $this->tipoImmagine;
    }

    function getPercorso() {
        return $this->percorso;
    }

    function getDescrizione() {
        return $this->descrizione;
    }

    function getPosizione() {
        return $this->posizione;
    }

    function setId($id): void {
        $this->id = $id;
    }

    function setIdContenuto($idContenuto): void {
        $this->idContenuto = $idContenuto;
    }

    function setTipoImmagine($tipoImmagine): void {
        $this->tipoImmagine = $tipoImmagine;
    }

    function setPercorso($percorso): void {
        $this->percorso = $percorso;
    }

    function setDescrizione($descrizione): void {
        $this->descrizione = $descrizione;
    }

    function setPosizione($posizione): void {
        $this->posizione = $posizione;
    }

}
